/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.properties;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ResourceUtil;
import com.aptana.ui.epl.UIEplPlugin;
import com.aptana.ui.properties.EplMessages;
import com.aptana.ui.properties.NaturesLabelProvider;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.progress.UIJob;

public class ProjectNaturesPage
extends PropertyPage
implements IWorkbenchPropertyPage,
ICheckStateListener,
SelectionListener {
    private CheckboxTableViewer fTableViewer;
    private MenuItem fSetPrimaryMenuItem;
    private Button fMakePrimaryButton;
    private IProject fProject;
    private String[] fCurrentProjectNatures;
    private String fPrimaryNature;
    private Map<String, String> fNatureDescriptions = new HashMap<String, String>();
    private Object[] fInitialCheckedItems;
    private String fInitialPrimaryNature;
    private boolean fNaturesModified;
    private NaturesLabelProvider fLabelProvider;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fProject = (IProject)this.getElement().getAdapter(IResource.class);
        try {
            this.fCurrentProjectNatures = this.fProject.isOpen() ? this.fProject.getDescription().getNatureIds() : new String[0];
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (String)EplMessages.ProjectNaturesPage_ERR_RetrieveNatures, (Throwable)e);
            this.fCurrentProjectNatures = new String[0];
        }
        this.fLabelProvider = new NaturesLabelProvider(this.fNatureDescriptions);
        this.fInitialPrimaryNature = this.fCurrentProjectNatures.length == 0 ? null : this.fCurrentProjectNatures[0];
        this.updatePrimaryNature(this.fInitialPrimaryNature);
        this.setDescription(MessageFormat.format(EplMessages.ProjectNaturesPage_Description, this.fProject.getName()));
        Label description = this.createDescriptionLabel(composite);
        description.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        Composite tableComposite = new Composite(composite, 0);
        tableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        tableComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)2176);
        Table table = this.fTableViewer.getTable();
        table.setLinesVisible(true);
        table.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        TableColumn column = new TableColumn(table, 16384);
        column.setWidth(350);
        this.fTableViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.fTableViewer.setComparator(this.getViewerComperator());
        this.fTableViewer.setInput((Object)this.fProject.getWorkspace());
        if (!this.fProject.isAccessible()) {
            this.fTableViewer.getControl().setEnabled(false);
        }
        this.fTableViewer.setCheckedElements((Object[])this.fCurrentProjectNatures);
        this.fTableViewer.addCheckStateListener((ICheckStateListener)this);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectNaturesPage.this.updateButtons();
            }
        });
        this.fInitialCheckedItems = this.fTableViewer.getCheckedElements();
        table.setMenu(this.createMenu(table));
        Composite buttons = new Composite(tableComposite, 0);
        buttons.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        buttons.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.fMakePrimaryButton = this.createButton(EplMessages.ProjectNaturesPage_LBL_MakePrimary, buttons);
        this.updateButtons();
        this.noDefaultAndApplyButton();
        return composite;
    }

    public boolean performOk() {
        if (!this.fNaturesModified && !this.isPrimaryNatureModified()) {
            return true;
        }
        Object[] checkedNatures = this.fTableViewer.getCheckedElements();
        final ArrayList<String> natureIds = new ArrayList<String>();
        Object[] objectArray = checkedNatures;
        int n = checkedNatures.length;
        int n2 = 0;
        while (n2 < n) {
            Object nature = objectArray[n2];
            natureIds.add(nature.toString());
            ++n2;
        }
        if (this.fPrimaryNature != null) {
            natureIds.remove(this.fPrimaryNature);
            natureIds.add(0, this.fPrimaryNature);
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IProjectDescription description = ProjectNaturesPage.this.fProject.getDescription();
                    description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
                    ProjectNaturesPage.this.fProject.setDescription(description, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(this.getControl().getShell()).run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (String)EplMessages.ProjectNaturesPage_ERR_SetNatures, (Throwable)e);
            return false;
        }
        this.resetProject();
        return true;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object[] checkedElements = this.fTableViewer.getCheckedElements();
        boolean bl = this.fNaturesModified = !Arrays.equals(this.fInitialCheckedItems, checkedElements);
        if (this.fPrimaryNature == null) {
            if (event.getChecked()) {
                this.updatePrimaryNature(event.getElement().toString());
                this.fTableViewer.refresh();
            }
        } else if (!event.getChecked() && this.isPrimary(event.getElement())) {
            if (checkedElements.length == 0) {
                this.updatePrimaryNature(null);
            } else {
                this.updatePrimaryNature(checkedElements[0].toString());
            }
            this.fTableViewer.refresh();
        }
        this.updateButtons();
    }

    public void widgetSelected(SelectionEvent e) {
        ISelection selection;
        Object source = e.getSource();
        if ((source == this.fSetPrimaryMenuItem || source == this.fMakePrimaryButton) && !(selection = this.fTableViewer.getSelection()).isEmpty() && selection instanceof StructuredSelection) {
            Object firstElement = ((StructuredSelection)selection).getFirstElement();
            this.fTableViewer.setChecked(firstElement, true);
            this.updatePrimaryNature(firstElement.toString());
            this.fTableViewer.refresh();
            this.updateButtons();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected Menu createMenu(Table table) {
        Menu menu = new Menu((Control)table);
        this.fSetPrimaryMenuItem = new MenuItem(menu, 8);
        this.fSetPrimaryMenuItem.setText(EplMessages.ProjectNaturesPage_LBL_SetAsPrimary);
        this.fSetPrimaryMenuItem.addSelectionListener((SelectionListener)this);
        return menu;
    }

    protected boolean isPrimary(Object element) {
        return this.fPrimaryNature != null && this.fPrimaryNature.equals(element);
    }

    protected void resetProject() {
        boolean reset = MessageDialog.openQuestion((Shell)this.getControl().getShell(), (String)EplMessages.ProjectNaturesPage_ResetTitle, (String)EplMessages.ProjectNaturesPage_ResetMessage);
        if (reset) {
            IRunnableWithProgress close = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    UIJob job = new UIJob(String.valueOf(EplMessages.ProjectNaturesPage_CloseProjectJob_Title) + "..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            CloseResourceAction closeAction = new CloseResourceAction(new IShellProvider(){

                                public Shell getShell() {
                                    return Display.getDefault().getActiveShell();
                                }
                            });
                            closeAction.selectionChanged((IStructuredSelection)new StructuredSelection(new Object[]{ProjectNaturesPage.this.fProject}));
                            closeAction.run();
                            monitor.done();
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                    try {
                        job.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    monitor.done();
                }
            };
            try {
                new ProgressMonitorJobsDialog(this.getControl().getShell()).run(true, true, close);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (String)EplMessages.ProjectNaturesPage_ERR_CloseProject, (Throwable)e);
            }
            IRunnableWithProgress open = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ProjectNaturesPage.this.fProject.open(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorJobsDialog(this.getControl().getShell()).run(true, true, open);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                IdeLog.logError((Plugin)UIEplPlugin.getDefault(), (String)EplMessages.ProjectNaturesPage_ERR_OpenProject, (Throwable)e);
            }
        }
    }

    private IStructuredContentProvider getContentProvider() {
        return new BaseWorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                IProjectNatureDescriptor[] natureDescriptors;
                if (!(o instanceof IWorkspace)) {
                    return new Object[0];
                }
                HashSet<String> elements = new HashSet<String>();
                Object[] objectArray = natureDescriptors = ((IWorkspace)o).getNatureDescriptors();
                int n = natureDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectNatureDescriptor descriptor = objectArray[n2];
                    String natureId = descriptor.getNatureId();
                    if (natureId != null && ResourceUtil.isAptanaNature((String)natureId)) {
                        elements.add(natureId);
                        ProjectNaturesPage.this.fNatureDescriptions.put(natureId, descriptor.getLabel());
                    }
                    ++n2;
                }
                objectArray = ProjectNaturesPage.this.fCurrentProjectNatures;
                n = objectArray.length;
                n2 = 0;
                while (n2 < n) {
                    IProjectNatureDescriptor nature = objectArray[n2];
                    if (elements.add((String)nature)) {
                        ProjectNaturesPage.this.fNatureDescriptions.put(nature, nature);
                    }
                    ++n2;
                }
                return elements.toArray();
            }
        };
    }

    private ILabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    private ViewerComparator getViewerComperator() {
        return new ViewerComparator((Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (ResourceUtil.isAptanaNature((String)o1)) {
                    return ResourceUtil.isAptanaNature((String)o2) ? o1.compareTo(o2) : -1;
                }
                return ResourceUtil.isAptanaNature((String)o2) ? 1 : o1.compareTo(o2);
            }
        });
    }

    private Button createButton(String text, Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    private void updateButtons() {
        StructuredSelection selection = (StructuredSelection)this.fTableViewer.getSelection();
        this.fMakePrimaryButton.setEnabled(!selection.isEmpty() && !this.isPrimary(selection.getFirstElement()));
    }

    private boolean isPrimaryNatureModified() {
        if (this.fInitialPrimaryNature == null) {
            return this.fPrimaryNature != null;
        }
        return !this.fInitialPrimaryNature.equals(this.fPrimaryNature);
    }

    private void updatePrimaryNature(String nature) {
        this.fPrimaryNature = nature;
        this.fLabelProvider.setPrimaryNature(this.fPrimaryNature);
    }
}

